VERSION 5.00
Begin VB.Form sensors 
   Caption         =   "Battery Analyser (C) Gary Smith - 2008.  www.bellasoft.co.uk"
   ClientHeight    =   9210
   ClientLeft      =   915
   ClientTop       =   1410
   ClientWidth     =   10125
   ForeColor       =   &H8000000A&
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   9210
   ScaleWidth      =   10125
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox Text_vstop 
      Height          =   285
      Left            =   8040
      TabIndex        =   31
      Top             =   8280
      Width           =   1815
   End
   Begin VB.TextBox Text_description 
      Height          =   285
      Left            =   1440
      TabIndex        =   27
      Top             =   7800
      Width           =   6255
   End
   Begin VB.TextBox Text_filename 
      Height          =   285
      Left            =   1440
      TabIndex        =   26
      Top             =   7440
      Width           =   2415
   End
   Begin VB.Timer Timer1 
      Interval        =   1000
      Left            =   9360
      Top             =   8760
   End
   Begin VB.CommandButton button_stop_recording 
      Caption         =   "Stop Recording"
      Height          =   735
      Left            =   4680
      TabIndex        =   7
      Top             =   8400
      Width           =   1455
   End
   Begin VB.Frame Frame1 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   5295
      Left            =   240
      TabIndex        =   3
      Top             =   1440
      Width           =   9735
      Begin VB.CheckBox relay 
         Caption         =   "Relay ON/OFF"
         Height          =   375
         Left            =   6960
         TabIndex        =   24
         Top             =   4560
         Width           =   2055
      End
      Begin VB.TextBox Text_seconds 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   405
         Left            =   8880
         TabIndex        =   21
         Top             =   720
         Width           =   495
      End
      Begin VB.TextBox Text_mins 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   405
         Left            =   8400
         TabIndex        =   20
         Top             =   720
         Width           =   495
      End
      Begin VB.TextBox Text_hours 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   405
         Left            =   7920
         TabIndex        =   19
         Top             =   720
         Width           =   495
      End
      Begin VB.TextBox Text_day 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   405
         Left            =   6240
         TabIndex        =   18
         Top             =   720
         Width           =   495
      End
      Begin VB.TextBox Text_month 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   405
         Left            =   6720
         TabIndex        =   17
         Top             =   720
         Width           =   495
      End
      Begin VB.TextBox Text_year 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   405
         Left            =   7200
         TabIndex        =   16
         Top             =   720
         Width           =   495
      End
      Begin VB.TextBox Text_readings 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   4200
         TabIndex        =   14
         Text            =   "00000"
         Top             =   4680
         Width           =   1215
      End
      Begin VB.TextBox Text_avg 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   405
         Left            =   2280
         TabIndex        =   13
         Text            =   "000"
         Top             =   4680
         Width           =   1575
      End
      Begin VB.TextBox text_atod_output 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   2057
            SubFormatType   =   1
         EndProperty
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   48
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1005
         Index           =   0
         Left            =   2280
         TabIndex        =   5
         Text            =   "00000"
         Top             =   1800
         Width           =   3615
      End
      Begin VB.TextBox text_atod_output 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   2057
            SubFormatType   =   1
         EndProperty
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   48
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1035
         Index           =   1
         Left            =   2280
         TabIndex        =   4
         Text            =   "00000"
         Top             =   3000
         Width           =   3615
      End
      Begin VB.Label Label13 
         Alignment       =   2  'Center
         BackColor       =   &H000000FF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Ensure that the correct load is used"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H0000FFFF&
         Height          =   975
         Left            =   6000
         TabIndex        =   34
         Top             =   2280
         Width           =   3375
      End
      Begin VB.Label Label12 
         Alignment       =   2  'Center
         BackColor       =   &H000000FF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "2000 mA MAX !"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   18
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   6000
         TabIndex        =   25
         Top             =   3240
         Width           =   3375
      End
      Begin VB.Label Label2 
         Caption         =   "Date (DDMMYY)"
         Height          =   255
         Left            =   6240
         TabIndex        =   23
         Top             =   480
         Width           =   1215
      End
      Begin VB.Label Label4 
         Caption         =   "Time"
         Height          =   375
         Left            =   8280
         TabIndex        =   22
         Top             =   480
         Width           =   615
      End
      Begin VB.Label Label6 
         Caption         =   "Readings Taken"
         Height          =   255
         Left            =   4200
         TabIndex        =   15
         Top             =   4440
         Width           =   1215
      End
      Begin VB.Label Label7 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Capacity (mA/H)"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   14.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   855
         Index           =   4
         Left            =   240
         TabIndex        =   12
         Top             =   4320
         Width           =   1935
      End
      Begin VB.Label Label7 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Average"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   14.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   3
         Left            =   2280
         TabIndex        =   11
         Top             =   4320
         Width           =   1575
      End
      Begin VB.Label Label_elapsed_m 
         BackColor       =   &H00000000&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "00000"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   51.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H0000FFFF&
         Height          =   1095
         Left            =   2280
         TabIndex        =   10
         Top             =   360
         Width           =   3735
      End
      Begin VB.Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00000000&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Test Duration (minutes)"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   14.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H0000FFFF&
         Height          =   1095
         Left            =   240
         TabIndex        =   9
         Top             =   360
         Width           =   1935
         WordWrap        =   -1  'True
      End
      Begin VB.Label Label7 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Current (mA)"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   14.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   975
         Index           =   1
         Left            =   240
         TabIndex        =   8
         Top             =   3000
         Width           =   1935
      End
      Begin VB.Label Label7 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Voltage (V)"
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   14.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   975
         Index           =   0
         Left            =   240
         TabIndex        =   6
         Top             =   1800
         Width           =   1935
      End
   End
   Begin VB.CommandButton button_start_recording 
      Caption         =   "Start Recording"
      Enabled         =   0   'False
      Height          =   735
      Left            =   3000
      TabIndex        =   2
      Top             =   8400
      Width           =   1455
   End
   Begin VB.CommandButton y 
      Caption         =   "EXIT"
      Height          =   735
      Left            =   360
      TabIndex        =   0
      Top             =   8400
      Width           =   1575
   End
   Begin VB.Label Label11 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Enter the Voltage at which the battery will be disconnected from the load and the test will finish"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1095
      Left            =   8040
      TabIndex        =   33
      Top             =   7200
      Width           =   1815
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      BackColor       =   &H000000FF&
      Caption         =   "Stop Voltage"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FFFF&
      Height          =   255
      Left            =   8040
      TabIndex        =   32
      Top             =   6960
      Width           =   1815
   End
   Begin VB.Label Label8 
      BackColor       =   &H0000FFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Notes:"
      Height          =   255
      Left            =   240
      TabIndex        =   30
      Top             =   7800
      Width           =   1215
   End
   Begin VB.Label Label9 
      BackColor       =   &H0000FFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Filename"
      Height          =   255
      Left            =   240
      TabIndex        =   29
      Top             =   7440
      Width           =   1215
   End
   Begin VB.Label Label10 
      BackColor       =   &H0000FFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Enter a filename and test description before starting the test."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   240
      TabIndex        =   28
      Top             =   6960
      Width           =   7575
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Battery Analyser "
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   36
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   975
      Left            =   240
      TabIndex        =   1
      Top             =   120
      Width           =   9735
   End
End
Attribute VB_Name = "sensors"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim Value As Integer
Dim input_select As Integer
Dim atod_output As Integer
Dim atod_voltage As Single
Dim atod_current As Integer
Dim atod_avg As Long
Dim monitor_flag As Boolean
Dim elapsed As Long
Dim avg_current As Single
Dim max_current As Single
Dim total_current As Single
Dim readings As Long




Private Sub button_exit_Click()
' Turn off relay before exiting program
sensors.relay.Value = 0
Call toggle_relay

End
End Sub

Private Sub button_save_Click()


End Sub

Private Sub button_start_recording_Click()
Dim lop As Integer
Dim response

relay.Enabled = False
monitor_flag = True
If Text_vstop.Text = "" Then
    response = MsgBox("You need to enter the voltage at which the battery will be disconnected.  Failure to do this will result in the battery being disharged to 0 Volts. Enter a value in the Stop Voltage box.  You can enter this value during the test. ", vbOKOnly, "WARNING")
End If
elapsed = 0
avg_current = 0
max_current = 0
total_current = 0
readings = 0

Open Text_filename.Text + ".txt" For Append As #1
Print #1, Text_description.Text
Close #1

While (monitor_flag = True)
    
    
    DoEvents
    Rem ***********************************************
    Rem ***** input select : 0=voltage, 1=current *****
    Rem ***********************************************
    For input_select = 0 To 1
        
        ' Take a reading
        ' Select voltage or current input to multiplexer
            Call select_input_channel(input_select)

        ' Get Average of 100 readings
        atod_avg = 0
        For lop = 1 To 1000
        ' Get AtoD output
            Call get_data(input_select, atod_output)
            atod_avg = atod_avg + atod_output
        Next lop
        atod_output = atod_avg / 1000
        
        ' Display AtoD Output
            
            ' Voltage
            If input_select = 0 Then
                atod_voltage = atod_output / 297.5
                ' Set number of decimal places depending on battery voltage
                If atod_voltage > 10 Then atod_voltage = Round(atod_voltage, 2) Else atod_voltage = Round(atod_voltage, 3)
                text_atod_output(input_select).Text = atod_voltage
            End If
            If atod_voltage < Val(Text_vstop.Text) And elapsed > 5 Then monitor_flag = False
            
            ' Current
            If input_select = 1 Then
                atod_current = atod_output / 1.203
                atod_current = atod_current - 9
                text_atod_output(input_select).Text = atod_current
                total_current = total_current + atod_current
                readings = readings + 1
                avg_current = total_current / readings
                Text_avg.Text = Round(avg_current * (elapsed / 3600), 1)
                Text_readings.Text = readings
            End If
            DoEvents
    Next input_select
    
    ' Add test results to the file
    Open Text_filename.Text + ".txt" For Append As #1
    Print #1, Label_elapsed_m, text_atod_output(0).Text, text_atod_output(1).Text
    Close #1
    Label_elapsed_m.Caption = Round(elapsed / 60, 1)
Wend
' Turn off lamp
Call relay_off
relay.Value = False
response = MsgBox("The test has finished", vbOKOnly, "Finished")
relay.Enabled = True

Open Text_filename.Text + ".txt" For Append As #1
Print #1, "*********************************************"
Print #1, "** BATTERY CAPACITY (mAh)"
Print #1, "**"
Print #1, "**  "; Text_avg.Text
Print #1, "**"
Print #1, "*********************************************"
Close #1







End Sub


Private Sub button_stop_recording_Click()
monitor_flag = False
End Sub


Private Sub Label14_Click()

End Sub

Private Sub Label15_Click()

End Sub

Private Sub Label17_Click()

End Sub

Private Sub relay_Click()
Call toggle_relay
End Sub

Private Sub Text2_Change()

End Sub

Private Sub Timer1_Timer()

' Only enable the start button once a filename and description have been entered
elapsed = elapsed + 1
If Text_filename.Text <> "" And Text_description.Text <> "" Then
    button_start_recording.Enabled = True
    Else: button_start_recording.Enabled = False
End If

' Display the date and time
Text_seconds = Mid$(Time, 7, 2)
    Text_mins = Mid$(Time, 4, 2)
    Text_hours = Mid$(Time, 1, 2)
    Text_day = Mid$(Date, 1, 2)
    Text_month = Mid$(Date, 4, 2)
    Text_year = Mid$(Date, 9, 2)

If Label12.ForeColor = vbYellow Then Label12.ForeColor = vbBlack Else Label12.ForeColor = vbYellow

End Sub

Private Sub y_Click()
Call relay_off
End
End Sub
